/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPartsRequestMarshaller
implements Marshaller<Request<ListPartsRequest>, ListPartsRequest> {
    @Override
    public Request<ListPartsRequest> marshall(ListPartsRequest listPartsRequest) {
        if (listPartsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPartsRequest> request = new DefaultRequest<ListPartsRequest>(listPartsRequest, "AmazonGlacier");
        String target = "Glacier.ListParts";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}?marker={marker};limit={limit}";
        uriResourcePath = uriResourcePath.replace("{accountId}", listPartsRequest.getAccountId() == null ? "" : StringUtils.fromString(listPartsRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", listPartsRequest.getVaultName() == null ? "" : StringUtils.fromString(listPartsRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replace("{uploadId}", listPartsRequest.getUploadId() == null ? "" : StringUtils.fromString(listPartsRequest.getUploadId()));
        uriResourcePath = uriResourcePath.replace("{marker}", listPartsRequest.getMarker() == null ? "" : StringUtils.fromString(listPartsRequest.getMarker()));
        uriResourcePath = uriResourcePath.replace("{limit}", listPartsRequest.getLimit() == null ? "" : StringUtils.fromString(listPartsRequest.getLimit()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

