/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.Operator;
import com.amazonaws.services.datapipeline.model.Query;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.Selector;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryObjectsRequestMarshaller
implements Marshaller<Request<QueryObjectsRequest>, QueryObjectsRequest> {
    @Override
    public Request<QueryObjectsRequest> marshall(QueryObjectsRequest queryObjectsRequest) {
        if (queryObjectsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<QueryObjectsRequest> request = new DefaultRequest<QueryObjectsRequest>(queryObjectsRequest, "DataPipeline");
        String target = "DataPipeline.QueryObjects";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Query query;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (queryObjectsRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(queryObjectsRequest.getPipelineId());
            }
            if ((query = queryObjectsRequest.getQuery()) != null) {
                jsonWriter.key("query");
                jsonWriter.object();
                ListWithAutoConstructFlag selectorsList = (ListWithAutoConstructFlag)query.getSelectors();
                if (!(selectorsList == null || selectorsList.isAutoConstruct() && selectorsList.isEmpty())) {
                    jsonWriter.key("selectors");
                    jsonWriter.array();
                    for (Selector selectorsListValue : selectorsList) {
                        Operator operator;
                        if (selectorsListValue == null) continue;
                        jsonWriter.object();
                        if (selectorsListValue.getFieldName() != null) {
                            jsonWriter.key("fieldName").value(selectorsListValue.getFieldName());
                        }
                        if ((operator = selectorsListValue.getOperator()) != null) {
                            ListWithAutoConstructFlag valuesList;
                            jsonWriter.key("operator");
                            jsonWriter.object();
                            if (operator.getType() != null) {
                                jsonWriter.key("type").value(operator.getType());
                            }
                            if (!((valuesList = (ListWithAutoConstructFlag)operator.getValues()) == null || valuesList.isAutoConstruct() && valuesList.isEmpty())) {
                                jsonWriter.key("values");
                                jsonWriter.array();
                                for (String valuesListValue : valuesList) {
                                    if (valuesListValue == null) continue;
                                    jsonWriter.value(valuesListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (queryObjectsRequest.getSphere() != null) {
                jsonWriter.key("sphere").value(queryObjectsRequest.getSphere());
            }
            if (queryObjectsRequest.getMarker() != null) {
                jsonWriter.key("marker").value(queryObjectsRequest.getMarker());
            }
            if (queryObjectsRequest.getLimit() != null) {
                jsonWriter.key("limit").value(queryObjectsRequest.getLimit());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

